unit AppTypesDB;

interface

uses System.Configuration, System.Drawing, System.Web.UI.WebControls, System.Data, System.Data.SqlClient;


type TAppTypesDB = Class
public
    constructor Create; 
    function GetProductCategories : SqlDataReader;
    function GetPayTypeCategories : SqlDataReader;
    function GetALLProductCategories : SqlDataReader;
    function GetAppPayTypes : SqlDataReader;
end;


implementation

constructor TAppTypesDB.Create;
begin
    inherited create;

end;

function TAppTypesDB.GetProductCategories : SqlDataReader;
var
 conn:SqlConnection;
 command:SqlCommand;
begin
  conn:=SqlConnection.Create(ConfigurationSettings.AppSettings[0]);
  command:=SqlCommand.Create('SELECT DISTINCT apptype, COUNT(apptype) as ct FROM Products GROUP BY apptype ORDER BY apptype ASC', conn);
  conn.Open;
  result := command.ExecuteReader(CommandBehavior.CloseConnection)
end;

function TAppTypesDB.GetPayTypeCategories : SqlDataReader;
var
 conn:SqlConnection;
 command:SqlCommand;
begin
  conn:=SqlConnection.Create(ConfigurationSettings.AppSettings[0]);
  command:=SqlCommand.Create('SELECT DISTINCT apppaytype, COUNT(apppaytype) as ct FROM Products GROUP BY apppaytype ORDER BY apppaytype ASC', conn);
  conn.Open;
  result := command.ExecuteReader(CommandBehavior.CloseConnection)
end;


function TAppTypesDB.GetALLProductCategories : SqlDataReader;
var
 conn:SqlConnection;
 command:SqlCommand;
begin

  conn:=SqlConnection.Create(ConfigurationSettings.AppSettings.Get('connectionString'));
  command:=SqlCommand.Create('SELECT name FROM apptypes ORDER BY name ASC', conn);

  conn.Open;

  result := command.ExecuteReader(CommandBehavior.CloseConnection)

end;

function TAppTypesDB.GetAppPayTypes : SqlDataReader;
var
 conn:SqlConnection;
 command:SqlCommand;
begin

  conn:=SqlConnection.Create(ConfigurationSettings.AppSettings.Get('connectionString'));
  command:=SqlCommand.Create('SELECT name FROM apppaytypes ORDER BY name ASC', conn);

  conn.Open;

  result := command.ExecuteReader(CommandBehavior.CloseConnection)

end;

end.
